(

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			-- here you return the UUID of the AMG node or graph that implements this material/map
			--
			-- Example:
			--    "c0a9d104-c110-49f9-8cf7-82171c872bdd"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- here you add to the "res" array for each map connection, the syntax is:
			--
			--    append res #( <string parametername>, <mtl/map submap> [, <string output>, [<context>]] )
			--
			-- <output>  is optional and will be "result" if not specified.
			-- <context> is an integer passed down to the functions of the node being connected
			--
			-- Example:
			--    if mtl.diffuse_map != undefined and mtl.diffuse_map_on do
			--        append res #( "diffuse", mtl.diffuse_map )                  -- connect "result" of the map to "diffuse" parameter
			--    if mtl.roughness_map != undefined and mtl.rougness_map_on do
			--        append res #( "rougness", mtl.diffuse_map, "resultFloat" )  -- connect "resultFloat" of the map to "roughness" parameter
			--    if mtl.bump_map != undefined and mtl.bump_map_on do
			--        append res #( "bump", mtl.diffuse_map, "resultFloat" )  -- connect "resultFloat" of the map to "roughness" parameter

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			-- here you add to the "res" array for each map connection, the syntax is:
			--
			--    append res #( <string parametername>, <value of matching type> )
			--
			-- Example:
			--    append res #( "diffuse",  mtl.diffuse_color)                   
			--    append res #( "rougness", mtl.diffuse_roughness )  

 			res
		)
	)

	AMGData()
)